import { FileHelpers, NodeHelpers } from "nextalys-node-helpers";
import { ScriptHelpers } from "./helpers";

async function installNodeGlobal() {
    await NodeHelpers.executeCommand('sudo npm i -g n');

}

async function installBaseApt() {
    await NodeHelpers.executeCommand('sudo apt-get update -y');
    await NodeHelpers.executeCommand('sudo apt-get upgrade -y');
    await NodeHelpers.executeCommand('sudo apt autoremove -y');
    // await NodeHelpers.executeCommand('sudo add-apt-repository ppa:certbot/certbot');
    await NodeHelpers.executeCommand('sudo apt-get install certbot -y');
    await NodeHelpers.executeCommand('sudo apt-get install git -y');

}

async function installApache() {
    await NodeHelpers.executeCommand('sudo apt-get install apache2 -y');
    await NodeHelpers.executeCommand('sudo a2enmod proxy proxy_http');
    await NodeHelpers.executeCommand('sudo a2enmod rewrite');
    await NodeHelpers.executeCommand('sudo a2enmod headers');
    await NodeHelpers.executeCommand('sudo a2enmod ssl');
    await NodeHelpers.executeCommand('sudo a2enmod proxy_wstunnel');
    await NodeHelpers.executeCommand('systemctl restart apache2');
    await NodeHelpers.executeCommand('systemctl status apache2.service');


}

async function installMysql() {
    await NodeHelpers.executeCommand('sudo apt-get install mysql-server -y');
}


async function configureSwapiness() {
    await NodeHelpers.executeCommand('sudo sysctl vm.swappiness=10');
    const fileConfig = '/etc/sysctl.conf';
    let fileContent = await FileHelpers.readFile(fileConfig);
    fileContent += "\n" + "vm.swappiness=10";
    await FileHelpers.writeFile(fileConfig, fileContent);
    await NodeHelpers.executeCommand('sudo swapoff -a');
    await NodeHelpers.executeCommand('sudo swapon -a');
}
async function fullProcess() {

    ScriptHelpers.log('Begin linux starter');

    ScriptHelpers.log('Base APT...');
    await installBaseApt();

    ScriptHelpers.log('Node global...');
    await installNodeGlobal();

    ScriptHelpers.log('Apache...');
    await installApache();

    ScriptHelpers.log('Mysql...');
    await installMysql();

    ScriptHelpers.log('Swapiness...');
    await configureSwapiness();

    ScriptHelpers.log('End linux starter');
}


try {
    fullProcess().then(() => {
        ScriptHelpers.endScript('Files copied with success !');
    }).catch((err) => {
        ScriptHelpers.handleError(err);
    });
}
catch (err) {
    ScriptHelpers.handleError(err);
}
