<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => ProductsCategories.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectProductsCategoriesModuleFrontController extends ModuleFrontController
{
    // $this->module is the instance of the module responsible of the controller.
    // $this->context delivers the result of Context::getContext()

    public function initContent()
    {
        $this->ajax = true;
        //  header('Content-disposition: attachment; filename=liste-produits.json');
        header('Content-type: application/json');

        $cle_module = Configuration::get('PRIXANCONNECT_CLE');
        if (Tools::getValue('key') == false || Tools::getValue('key') != $cle_module) {
            die(Tools::jsonEncode('erreur d\'autorisation'));
            return;
        }
        //parametre
        $idShop = (int) $this->context->shop->id;
        if (Tools::getValue('id_shop') != null && (int) Tools::getValue('id_shop') != null > 0) {
            $idShop = (int) Tools::getValue('id_shop');
        }
        $categories = Category::getNestedCategories();
        $categories = array_values($categories);
        die(Tools::jsonEncode($categories));
    }
}
