<?php


class NxsHelpers

{
    public static $plugin_version;
    public static function getAdvancedPackIds()
    {
        $check_advanced_pack_plugin_active_results =  Db::getInstance()->executeS('select name from `' . _DB_PREFIX_ . 'module` WHERE name="pm_advancedpack" and active=1;');
        $check_advanced_pack_plugin_active = count($check_advanced_pack_plugin_active_results) > 0;
        $advanced_pack_ids = array();
        if ($check_advanced_pack_plugin_active) {
            try {
                $ids_from_query =  Db::getInstance()->executeS('select id_pack from `' . _DB_PREFIX_ . 'pm_advancedpack`');

                if (!empty($ids_from_query)) {
                    foreach ($ids_from_query as $row_wrapper) {
                        $advanced_pack_ids[] = (int) $row_wrapper['id_pack'];
                    }
                }
                // $check_advanced_pack = true;
            } catch (Exception $exc) {
                //throw $th;
                // $check_advanced_pack = $exc->getMessage();
                $advanced_pack_ids = array();
            }
        }

        return $advanced_pack_ids;
    }
    public static function productIsPack($id_product, $advanced_pack_ids)
    {
        return self::productIsAdvancedPack($id_product, $advanced_pack_ids) || Pack::isPack((int) $id_product);
    }
    public static function productIsAdvancedPack($id_product, $advanced_pack_ids)
    {
        return (in_array($id_product, $advanced_pack_ids));
    }

    public static function getProductsLink($shop_id)
    {
        $prixan_key = Configuration::get('PRIXANCONNECT_CLE');
        if (!$prixan_key) {
            return '';
        }

        $moduleLink = Context::getContext()->link->getModuleLink('prixanconnect', 'Products');
        $endsWithQuestionMark = false;
        if (strpos($moduleLink, '?') === false) {
            $moduleLink .= '?';
            $endsWithQuestionMark = true;
        }

        $parameters = array();
        $parameters[] = 'key=' . $prixan_key;

        if (strpos($moduleLink, 'id_lang') === false) {
            $parameters[] = 'id_lang' . '=' . (int) Configuration::get('PS_LANG_DEFAULT');
        }
        if (strpos($moduleLink, 'id_shop') === false) {
            $parameters[] = 'id_shop' . '=' . (int)$shop_id;
        }
        if (!$endsWithQuestionMark) {
            $moduleLink .= '&';
        }

        $moduleLink .= join('&', $parameters);

        //  $lien_base = _PS_BASE_URL_ . __PS_BASE_URI__;
        //  $link =   $lien_base  . 'module/prixanconnect/Products?key=' . $prixan_key . '&id_lang=' . (int) Configuration::get('PS_LANG_DEFAULT') . '&id_shop=' . (int) $this->context->shop->id;
        return $moduleLink;
    }
    private static function endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if (!$length) {
            return true;
        }
        return substr($haystack, -$length) === $needle;
    }
    public static function getModuleBaseUrl()
    {
        $defaultRoute = Context::getContext()->link->getModuleLink('prixanconnect', '');
        if (self::endsWith($defaultRoute, 'default')) {
            $defaultRoute = substr($defaultRoute, 0, strrpos($defaultRoute, 'default'));
        }
        if (self::endsWith($defaultRoute, '/')) {
            $defaultRoute = substr($defaultRoute, 0, strrpos($defaultRoute, '/'));
        }

        if (strpos($defaultRoute, '&controller=default') !== false) {
            $defaultRoute = str_replace('&controller=default', '', $defaultRoute);
        }
        if (strpos($defaultRoute, '&id_lang=1') !== false) {
            $defaultRoute = str_replace('&id_lang=1', '', $defaultRoute);
        }
        return $defaultRoute;
    }
    public static function getPrixanConnectPayload($shop_id)
    {
        $prixan_key = Configuration::get('PRIXANCONNECT_CLE');
        if (!$prixan_key) {
            $prixan_key = null;
        }
        return array(
            "url" => self::getProductsLink($shop_id),
            "key" => $prixan_key,
            "domain" => $_SERVER['SERVER_NAME'],
            "cms" => "prestashop",
            "version" => _PS_VERSION_,
            "ip" => self::getUserIpAddr(),
            'module_base_url' => self::getModuleBaseUrl(),
            'id_shop' => (int) $shop_id,
            'plugin_version' => self::$plugin_version,
            'shops' => self::getShopsList(),
        );
    }
    private static function getShopsList()
    {

        $shops = array();
        $query = "SELECT sht.`id_shop` as id_shop,
            sht.`name` as name ,
            sht.`active` as active ,
            sht.`deleted` as deleted ,
            shurl.`domain` as domain ,
           shurl.`domain_ssl` as domain_ssl ,
            shurl.`physical_uri` as physical_uri ,
             shurl.`virtual_uri` as virtual_uri
             FROM `" . _DB_PREFIX_ . "shop` sht LEFT JOIN `" . _DB_PREFIX_ . "shop_url` shurl
               ON sht.`id_shop`=shurl.`id_shop`";

        // $query = "SELECT sht.`id_shop` as id_shop,
        //    sht.`name` as name ,
        //    sht.`active` as active ,
        //    sht.`deleted` as deleted 
        //     FROM `" . _DB_PREFIX_ . "shop` sht";

        $results = Db::getInstance()->executeS($query);

        if ($results) {
            foreach ($results as $shop_data) {
                $shops[] = $shop_data;
            }
        } else {
            $shops = Db::getInstance()->getMsgError();
        }
        return $shops;
    }
    private static function getUserIpAddr()
    {
        $ip = "";
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            //ip from share internet
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            //ip pass from proxy
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

    public static function nxs_send_request_base($url, $method, $data, $is_json)
    {
        $final_response =   array('response' => null, 'code' => null);

        try {
            $curl = curl_init($url);

            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

            if ($method === 'POST') {
                curl_setopt($curl, CURLOPT_POST, true);
            }
            curl_setopt($curl, CURLOPT_HEADER, true);

            if ($is_json) {
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                $payload = json_encode($data, JSON_UNESCAPED_SLASHES);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);
            } else {
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
            }
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($curl);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $headers_str = substr($response, 0, $header_size);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $body = substr($response, $header_size);

            $curl_error = '';
            if ($response === false) {
                $curl_error = curl_error($curl);
            }
            curl_close($curl);
            $final_response =   array('response' => $body, 'code' => $httpcode, 'curl_response' => $response, 'curl_error' => $curl_error);
        } catch (Exception $exc) {
            $final_response['exception'] = $exc->getMessage();
        }
        return $final_response;
    }
}
