<?php

/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2020 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Prixanconnect extends Module
{
    protected $config_form = false;
    private static $_bo_menu = array(
        array(
            'class_name' => 'AdminPrixan',
            'name' => 'Prixan Connect',
            'tab' => 'SELL',
        ),
    );

    public function __construct()
    {
        $this->name = 'prixanconnect';
        $this->tab = 'administration';
        $this->version = '1.54';
        $this->author = 'Prixan';
        $this->need_instance = 0;

        require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'controllers/helpers.php';

        NxsHelpers::$plugin_version = $this->version;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Prixan connect');
        $this->description = $this->l('Export des prix produits et déclinaisons pour Prixan');

        $this->confirmUninstall = $this->l('');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        Configuration::updateValue('PRIXANCONNECT_LIVE_MODE', false);
        // Configuration::updateValue('PRIXANCONNECT_CLE', md5(uniqid()));

        return parent::install() &&
            $this->installTab() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader')
            //;;
        ;
        //  && $this->registerHook('moduleRoutes');
    }

    public function uninstall()
    {
        Configuration::deleteByName('PRIXANCONNECT_LIVE_MODE');
        foreach (self::$_bo_menu as $v) {
            $tab = Tab::getInstanceFromClassName($v['class_name']);
            $tab->delete();
        }

        return parent::uninstall();
    }

    public function installTab()
    {
        $result = true;
        foreach (self::$_bo_menu as $v) {
            if (Tab::getIdFromClassName($v['class_name'])) {
                continue;
            }
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $v['class_name'];
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $v['name'];
            }
            if (version_compare(_PS_VERSION_, '1.7.0', '>=') === true && $v['tab']) {
                $tabId = Tab::getIdFromClassName($v['tab']);
                if ($tabId) {
                    $tab->id_parent = (int) $tabId;
                }
            }
            $tab->module = $this->name;
            $result &= $tab->add();
        }
        return $result;
    }

    private function checkPrixanConnection()
    {
        $prixan_key = Configuration::get('PRIXANCONNECT_CLE');
        if (!$prixan_key) {
            return;
        }
        require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'controllers/helpers.php';

        $data = NxsHelpers::getPrixanConnectPayload($this->context->shop->id);

        // $baseUrl = _PS_BASE_URL_ . __PS_BASE_URI__;
        // $data = array(
        //     "url" => $this->getProductsLink(),
        //     "key" => $prixan_key,
        //     "domain" => $_SERVER['SERVER_NAME'],
        //     "cms" => "prestashop",
        //     "version" => _PS_VERSION_,
        //     "ip" => $this->getUserIpAddr(),
        //     'module_base_url' => $this->getModuleBaseUrl(),
        //     'id_shop' => (int) $this->context->shop->id,
        //     'plugin_version' => $this->version,
        //     'shops' => $this->getShopsList(),
        // );

        foreach ($data as $key => $value) {
            $this->context->smarty->assign('nxs_injected_js_' . $key, json_encode($value));
        }

        // $response_wrapper = NxsHelpers::nxs_send_request_base('https://app.prixan.com/check-prixan-connect', 'POST', $data, true);
        $ok = false;
        // $json_data = null;
        // $prixan_error_message = '';

        // if (($response_wrapper['code'] === 200 ||  $response_wrapper['code'] === 404) && isset($response_wrapper['response']) && !empty($response_wrapper['response'])) {
        //     $json_data = json_decode($response_wrapper['response'], true);
        //     // $success_key = 'check';
        //     // $success_value = 'OK';
        //     $success_key = 'check';
        //     $success_value = 'success';

        //     if ($json_data && isset($json_data[$success_key]) && $json_data[$success_key] === $success_value) {
        //         $ok = true;
        //     } else if (isset($json_data['error'])) {
        //         $prixan_error_message = $json_data['error'];
        //     }
        // }

        // if (isset($response_wrapper['response'])) {
        // }
        // return $form . '<br/><br/><br/><br/>' . json_encode($data);

        $this->context->smarty->assign('prixan_connection_ok', $ok);
        // $this->context->smarty->assign('prixan_error_message', $prixan_error_message);


        $debug_mode = (_PS_MODE_DEV_ === true) || ($_SERVER['SERVER_NAME'] === 'ps16.prixan.info') || ($_SERVER['SERVER_NAME'] === 'ps17.prixan.info');
        // $debug_mode = true;
        // $debug_mode = false;
        $this->context->smarty->assign('debug_mode', $debug_mode);
        // $this->context->smarty->assign('retour_prixan', $response_wrapper['response']);
        // $this->context->smarty->assign('retour_prixan_full', json_encode($response_wrapper, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
        // $this->context->smarty->assign('envoi_prixan', json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

        // $this->context->smarty->assign('debug_data',  $prixan_error_message);
        // $this->context->smarty->assign('debug_data', json_encode($json_data));

        // $this->context->smarty->assign('debug_data',  $moduleLink);
        // $this->context->smarty->assign('debug_data', _PS_BASE_URL_);
    }



    // private function getProductsLink()
    // {
    //     $prixan_key = Configuration::get('PRIXANCONNECT_CLE');
    //     if (!$prixan_key) {
    //         return '';
    //     }

    //     $moduleLink = Context::getContext()->link->getModuleLink('prixanconnect', 'Products');
    //     $endsWithQuestionMark = false;
    //     if (strpos($moduleLink, '?') === false) {
    //         $moduleLink .= '?';
    //         $endsWithQuestionMark = true;
    //     }

    //     $parameters = array();
    //     $parameters[] = 'key=' . $prixan_key;

    //     if (strpos($moduleLink, 'id_lang') === false) {
    //         $parameters[] = 'id_lang' . '=' . (int) Configuration::get('PS_LANG_DEFAULT');
    //     }
    //     if (strpos($moduleLink, 'id_shop') === false) {
    //         $parameters[] = 'id_shop' . '=' . (int) $this->context->shop->id;
    //     }
    //     if (!$endsWithQuestionMark) {
    //         $moduleLink .= '&';
    //     }

    //     $moduleLink .= join('&', $parameters);

    //     //  $lien_base = _PS_BASE_URL_ . __PS_BASE_URI__;
    //     //  $link =   $lien_base  . 'module/prixanconnect/Products?key=' . $prixan_key . '&id_lang=' . (int) Configuration::get('PS_LANG_DEFAULT') . '&id_shop=' . (int) $this->context->shop->id;
    //     return $moduleLink;
    // }
    /**
     * Load the configuration form
     */
    public function getContent()
    {
        require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'controllers/helpers.php';

        /**
         * If values have been submitted in the form, process.
         */
        if (((bool) Tools::isSubmit('submitPrixanconnectModule')) == true) {
            $this->postProcess();
        }

        $this->checkPrixanConnection();

        // $shopurl = new ShopUrl($this->context->shop->id);
        // $url = $shopurl->getURL();
        $baseUrl = _PS_BASE_URL_ . __PS_BASE_URI__;

        $this->context->smarty->assign('module_dir', $this->_path);
        //$this->context->smarty->assign('lien_base', _PS_BASE_URL_ . __PS_BASE_URI__);
        //$this->context->smarty->assign('lang_defaut', (int) Configuration::get('PS_LANG_DEFAULT'));
        //$this->context->smarty->assign('shop_defaut', (int) $this->context->shop->id);
        $this->context->smarty->assign('cle', Configuration::get('PRIXANCONNECT_CLE'));
        $this->context->smarty->assign('products_link', NxsHelpers::getProductsLink($this->context->shop->id));
        $this->context->smarty->assign('module_base_url', NxsHelpers::getModuleBaseUrl());
        $this->context->smarty->assign('logo_url', $baseUrl . 'modules/' . $this->name . '/views/img');
        $this->context->smarty->assign('plugin_version', $this->version);

        $output = $this->context->smarty->fetch($this->local_path . 'views/templates/admin/configure.tpl');

        return $output . $this->renderForm();
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitPrixanconnectModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'name' => 'PRIXANCONNECT_CLE',
                        'label' => $this->l('Clé'),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        return array(
            'PRIXANCONNECT_CLE' => Configuration::get('PRIXANCONNECT_CLE'),
        );
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key));
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be loaded in the BO.
     */
    public function hookBackOfficeHeader()
    {
        // if (Tools::getValue('module_name') == $this->name) {
        //     $this->context->controller->addJS($this->_path . 'views/js/back.js');
        //     $this->context->controller->addCSS($this->_path . 'views/css/back.css');
        // }

        $this->context->controller->addJS($this->_path . 'views/js/back.js?v=' . $this->version);
        $this->context->controller->addCSS($this->_path . 'views/css/back.css');
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path . '/views/js/front.js');
        $this->context->controller->addCSS($this->_path . '/views/css/front.css');
    }

    // public function hookModuleRoutes()
    // {
    //     return [
    //         'module-prixanconnect-products' => [
    //             'controller' => 'Products',
    //             //'rule' => 'mymodule{/:id}',
    //             // 'keywords' => [
    //             //     'id' => ['regexp' => '[_a-zA-Z0-9_-]+', 'param' => 'id']
    //             // ],
    //             // 'params' => [
    //             //     'fc' => 'module',
    //             //     'module' => 'mymodule'
    //             // ]
    //         ],
    //         'module-prixanconnect-products-count' => [
    //             'controller' => 'ProductsCount',
    //             //'rule' => 'mymodule{/:id}',
    //             // 'keywords' => [
    //             //     'id' => ['regexp' => '[_a-zA-Z0-9_-]+', 'param' => 'id']
    //             // ],
    //             // 'params' => [
    //             //     'fc' => 'module',
    //             //     'module' => 'mymodule'
    //             // ]
    //         ],

    //     ];
    // }
}
