{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
	* @copyright 2007-2020 PrestaShop SA
	* @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
	* International Registered Trademark & Property of PrestaShop SA
	*}
	{literal}
	<style type="text/css">
		.prixan_title {
			color: #f7a056;
		}

		.col-sm-1.col-1 {
			width: 4%;
			font-size: 16px;
		}

		.prixan_title strong {
			font-size: 16px;
		}

		.about_title {
			font-size: 22px;
		}

		.logo_image {
			max-width: 90%;
		}

		@media screen and (max-width: 750px) {
			.logo_image {
				max-width: 100%;
			}

			.col-sm-1.col-1 {
				width: 100%;
				font-size: 16px;
			}
		}
	</style>
	{/literal}
	<div class="panel">
		<!-- <h3><i class="icon icon-credit-card"></i> {l s='prixan' mod='prixan'}</h3>
	<p>{l s='price compare with you concurents' mod='prixan'}</p> -->
		<div class="row">
			<div>
				<img class="logo_image" src="{$logo_url|escape:'htmlall':'UTF-8'}/prixan-logo-white-bg.jpg">
			</div>
			<div style="margin-top:16px">
				<strong>{l s='COMPETITION MONITORING AND AUTOMATED PRICING' mod='prixan'}</strong>
			</div>

			<div>
				<div id="access-to-prixan-dashboard-buttons-wrapper"  class="prixan-btns-wrapper">
					<a target="_blank" class="prixan-btn" href="https://app.prixan.com/fr/dashboard/">
						<i class="material-icons mi-account_circle">account_circle</i>
						<span>Mon Dashboard Prixan</span>
					</a>
				</div>
				<div id="subscribe-to-prixan-buttons-wrapper"  class="prixan-btns-wrapper">
					<a target="_blank" class="prixan-btn" href="https://app.prixan.com/">
						<i class="material-icons mi-account_circle">account_circle</i>
						<span>Connectez-vous</span>
					</a>
					<a target="_blank" class="prixan-btn" href="https://app.prixan.com/fr/signup">
						<i class="material-icons">edit</i>
						<span>Inscrivez-vous</span>
					</a>
				</div>
			</div>
		</div>
	</div>
	<div class="panel">
		<!-- <h3><i class="icon icon-credit-card"></i> {l s='prixan' mod='prixan'}</h3>
	<p>{l s='price compare with you concurents' mod='prixan'}</p> -->
		<div class="row">
			<div class="col-sm-10 text-left">
				<p class="clearfix"></p>
				<p class="about_title"><strong>{l s='About Prixan' mod='prixan'}</strong> ({l s='plugin' mod='prixan'}
					V{$plugin_version})</p>
				<p>{l s='Prixan is a competitive intelligence software that automatically monitors all your
					competitors.' mod='prixan'}</p>
				<p>{l s='A robot goes through your competitors sites every day and monitors the products you have
					in common with them.' mod='prixan'}</p>
				<p>{l s='The information in this module is continuously updated and allows you to:' mod='prixan'}</p>
				<ul>
					<li>{l s='automate your competitive monitoring of sites and marketplaces' mod='prixan'}</li>
					<li>{l s='control your current margins and those you would have by aligning yourself to the best
						price' mod='prixan'}</li>
					<li>{l s='automatically align your prices to the best or under the best price while controlling your
						margin' mod='prixan'}</li>
					<li>{l s='monitor your margins by brand or product category' mod='prixan'}</li>
				</ul>

			</div>
		</div>
	</div>

	<div class="panel">
		<h3><i class="icon icon-tags"></i> {l s='Connexion avec Prixan' mod='prixanconnect'}</h3>

		<div id="check-prixan-connection-result-workflow-wrapper">
		</div>
		
		{if $debug_mode}
		<div>
			<div style="text-decoration:underline;margin:10px auto">ENVOI A PRIXAN : </div>
			<div style="border:1px solid black;padding:10px" id="send-prixan-data-debug"></div>

			<div style="text-decoration:underline;margin:10px auto">RETOUR DE PRIXAN : </div>
			<div style="border:1px solid black;padding:10px" id="response-prixan-data-debug"></div>


		<!--	<div style="text-decoration:underline;margin:10px auto">RETOUR DE PRIXAN (COMPLET): </div>
			<div style="border:1px solid black;padding:10px" id="response-prixan-data-debug-full"></div>-->
		</div>
		{/if}

		{if isset($debug_data)}
		<div style="text-decoration:underline;margin:10px auto">DEBUG : </div>
		<div style="border:1px solid black;padding:10px">{$debug_data}</div>
		{/if}


	</div>
	{if $debug_mode}
	<div class="panel">
		<h3><i class="icon icon-tags"></i> {l s='Base URL Module' mod='prixanconnect'}</h3>
		<p>
			URL : {$module_base_url|escape:'htmlall':'UTF-8'}
		</p>
		<div style="margin:30px auto"></div>
		<h3><i class="icon icon-tags"></i> {l s='Exemple de lien pour l\'export ' mod='prixanconnect'}</h3>
		<p>
			<a target="_blank"
				href="{$products_link|escape:'htmlall':'UTF-8'}">{$products_link|escape:'htmlall':'UTF-8'}</a>
		</p>

	</div>
	{/if}
	
	<script>
	var nxs_injected_js_url = {$nxs_injected_js_url};
	var nxs_injected_js_key = {$nxs_injected_js_key};
	var nxs_injected_js_domain = {$nxs_injected_js_domain};
	var nxs_injected_js_cms = {$nxs_injected_js_cms};
	var nxs_injected_js_version = {$nxs_injected_js_version};
	var nxs_injected_js_ip = {$nxs_injected_js_ip };
	var nxs_injected_js_module_base_url = {$nxs_injected_js_module_base_url};
	var nxs_injected_js_id_shop = {$nxs_injected_js_id_shop};
	var nxs_injected_js_plugin_version = {$nxs_injected_js_plugin_version};
	var nxs_injected_js_shops = {$nxs_injected_js_shops};
	</script>