<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => ConnectionTest.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectConnectionTestModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        header('Content-type: application/json');
        // $request->getContent();
        die(Tools::jsonEncode(array('check' => 'you must call this url with POST method')));
    }

    public function postProcess()
    {
        header('Content-type: application/json');
        $checkPrixanConnect = (Tools::getValue('check-prixan-connect') === 'true');
        $testProductsFetch = (Tools::getValue('test-products-fetch') === 'true');
        $response = array('success' => false);
        if ($testProductsFetch) {
            $response =  $this->testProductsFetch();
        } else if ($checkPrixanConnect) {
            $response =  $this->checkPrixanConnect();
        }
        die(Tools::jsonEncode($response));
    }
    private function checkPrixanConnect()
    {
        $response = array('success' => false);
        try {
            require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '../helpers.php';
            // $response_wrapper = NxsHelpers::nxs_send_request_base('https://app.prixan.com/check-prixan-connect', 'POST', $data, true);
            // $response['success'] = $response_wrapper['code'] === 200;
            // $response['data'] = $response_wrapper['body'];

            $response['success'] = true;
        } catch (Exception $exc) {
            $response['success'] = false;
            $response['error'] = $exc->getMessage();
        }
        return $response;
    }
    private function testProductsFetch()
    {
        $response = array('success' => false);
        try {
            require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '../helpers.php';
            $data = NxsHelpers::getPrixanConnectPayload($this->context->shop->id);
            if (!$data  || !$data['url']) {
                throw new Exception('No url fetch');
            }
            $response_wrapper = NxsHelpers::nxs_send_request_base($data['url'] . '&limit=1', 'GET', null, true);
            $response['success'] = $response_wrapper['code'] === 200;
            if ($response['success']) {
                $response['data'] = $response_wrapper['response'];
            }
        } catch (Exception $exc) {
            $response['success'] = false;
            $response['error'] = $exc->getMessage();
        }
        return $response;
    }
}
