<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => products.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectProductsModuleFrontController extends ModuleFrontController
{
    // $this->module is the instance of the module responsible of the controller.
    // $this->context delivers the result of Context::getContext()

    private function getProductsQuery($idShop, $langID, $only_active, $date_from = null, $product_ids = array(), $limit = '')
    {
        $query = "SELECT prshop.`id_product`,
        pashop.`id_product_attribute` as idattr ,

        attlang.name   as valeur_attr  ,
        grouplang.`name`   as nom_attr  ,

           imgshop.`id_image`,
            pa.`ean13` , pa.`reference`
           , pa.`wholesale_price`,
                  pa.`supplier_reference`
         FROM `" . _DB_PREFIX_ . "product_shop` AS prshop
         LEFT JOIN `" . _DB_PREFIX_ . "product_attribute_shop` AS pashop ON pashop.`id_product` = prshop.`id_product` AND pashop.`id_shop` = prshop.`id_shop`
         LEFT JOIN `" . _DB_PREFIX_ . "image_shop` AS imgshop ON imgshop.`id_product` = prshop.`id_product` AND imgshop.`id_shop` = prshop.`id_shop` AND imgshop.`cover` = 1
         LEFT JOIN `" . _DB_PREFIX_ . "product_attribute` AS pa ON pa.`id_product_attribute` = pashop.`id_product_attribute`
         LEFT JOIN `" . _DB_PREFIX_ . "product_attribute_combination` AS combi ON combi.`id_product_attribute` = pashop.`id_product_attribute`
         LEFT JOIN `" . _DB_PREFIX_ . "attribute` as attr ON attr.`id_attribute` = combi.`id_attribute`
         LEFT JOIN `" . _DB_PREFIX_ . "attribute_lang` as attlang ON attlang.`id_attribute` = attr.`id_attribute` AND attlang.`id_lang` = " . $langID . "
         LEFT JOIN `" . _DB_PREFIX_ . "attribute_group_lang`AS grouplang ON grouplang.`id_attribute_group` = attr.`id_attribute_group` AND grouplang.`id_lang` = attlang.`id_lang`
         WHERE prshop.`id_shop` = " . $idShop;
        if ($only_active === 1) {
            $query .= " AND prshop.`active` = 1";
        }
        if (!empty($date_from)) {
            $query .= " AND prshop.`date_upd` > '$date_from'";
        }

        if (!empty($product_ids) && count($product_ids) > 0) {
            $query .= ' AND prshop.`id_product` IN (' . join(',', $product_ids) . ') ';
        }

        $query .= " ORDER BY prshop.`id_product`  $limit";

        return $query;
    }

    private function getProductAttributesDataFromQueryResult($id_prod_current, &$main_products_array, $rowListeProd)
    {
        $product_index_from_array = array_search($id_prod_current, array_column($main_products_array, 'id'));

        $tab_attributs = array();
        $tab_attributs_data = array();

        if ($product_index_from_array !== false) {
            //  $debug_tab[]= $main_products_array[$product_index_from_array];
            if (!$main_products_array[$product_index_from_array]['declinaisons']) {
                $main_products_array[$product_index_from_array]['declinaisons'] = array();
            }
            $tab_attributs = $main_products_array[$product_index_from_array]['declinaisons'];
        }

        try {
            // Est-ce que le produit en cours a des déclinaisons
            if (isset($rowListeProd['idattr']) && $rowListeProd['idattr']) {
                $tab_liste_attr = array();
                // $tab_nom_attr = explode("|", $rowListeProd['nom_attr']);
                // $tab_val_attr = explode("|", $rowListeProd['valeur_attr']);
                // for ($i = 0; $i < count($tab_nom_attr); $i++) {
                //     $tab_liste_attr[$tab_nom_attr[$i]] = $tab_val_attr[$i];
                // }

                // $tab_liste_attr[$rowListeProd['nom_attr']] = $rowListeProd['valeur_attr'];

                // $tab_attributs_data = array_merge(
                //     array(
                //         'ean13' => $rowListeProd['ean13'],
                //         'prix_declinaison' => null,
                //         'prix_achat' => $rowListeProd['wholesale_price'],
                //         'ref_fournisseur' => $rowListeProd['supplier_reference'],
                //         'id' => $rowListeProd['idattr']
                //     ),
                //     $tab_liste_attr
                // );

                $tab_attributs_data =
                    array(
                        'ean13' => $rowListeProd['ean13'],
                        'prix_declinaison' => null,
                        'prix_achat' => $rowListeProd['wholesale_price'],
                        'ref_fournisseur' => $rowListeProd['supplier_reference'],
                        'reference' => $rowListeProd['reference'],
                        'id' => $rowListeProd['idattr'],
                        'attributes' => array(),
                        // 'key' => $rowListeProd['nom_attr'],
                        // 'value' => $rowListeProd['valeur_attr'],
                    );

                $product_attr_index_from_array = array_search($rowListeProd['idattr'], array_column($tab_attributs, 'id'), false);
                if ($product_attr_index_from_array !== false) {
                    if (isset($rowListeProd['nom_attr']) && $rowListeProd['nom_attr'] && isset($rowListeProd['valeur_attr']) && $rowListeProd['valeur_attr']) {
                        $tab_attributs[$product_attr_index_from_array]['attributes'][] = array('key' => $rowListeProd['nom_attr'], 'value' => $rowListeProd['valeur_attr']);
                    }
                } else {
                    if (isset($rowListeProd['nom_attr']) && $rowListeProd['nom_attr'] && isset($rowListeProd['valeur_attr']) && $rowListeProd['valeur_attr']) {
                        $tab_attributs_data['attributes'][] = array('key' => $rowListeProd['nom_attr'], 'value' => $rowListeProd['valeur_attr']);
                    }
                    array_push($tab_attributs, $tab_attributs_data);
                }

                if ($product_index_from_array !== false) {
                    $main_products_array[$product_index_from_array]['declinaisons'] = $tab_attributs;
                }
            }
        } catch (Exception $exc_decl) {
            //throw $th;
        }

        return $tab_attributs;
    }

    private function loadProductDeclinaisonsData(&$main_products_array, $idShop, $langID, $only_active, $product_id)
    {
        $last_product_query = $this->getProductsQuery($idShop, $langID, $only_active, null, array($product_id), '');
        $last_product_query_results = Db::getInstance()->executeS($last_product_query);

        $product_index_from_array = array_search($product_id, array_column($main_products_array, 'id'));

        $main_products_array[$product_index_from_array]['declinaisons'] = array();

        foreach ($last_product_query_results as $last_product_query_results_row) {
            $id_prod_current = (int) $last_product_query_results_row['id_product'];
            $this->getProductAttributesDataFromQueryResult($id_prod_current, $main_products_array, $last_product_query_results_row);
        }
    }

    public function initContent()
    {

        $main_products_array = array();
        try {
            $this->ajax = true;
            // header('Content-disposition: attachment; filename=liste-produits.json');
            header('Content-type: application/json');

            $cle_module = Configuration::get('PRIXANCONNECT_CLE');
            if (Tools::getValue('key') == false || Tools::getValue('key') != $cle_module) {
                die(Tools::jsonEncode('erreur d\'autorisation'));
                return;
            }

            //parametre
            $langID = (int) Configuration::get('PS_LANG_DEFAULT');
            $idShop = (int) $this->context->shop->id;

            if (Tools::getValue('id_lang') != null && (int) Tools::getValue('id_lang') > 0) {
                $langID = (int) Tools::getValue('id_lang');
            }
            if (Tools::getValue('id_shop') != null && (int) Tools::getValue('id_shop') != null > 0) {
                $idShop = (int) Tools::getValue('id_shop');
            }

            $only_active = 1;
            if (Tools::getValue('only_active') != null && ((int) Tools::getValue('only_active')) === 0) {
                $only_active = 0;
            }

            $limitStr = '';

            if (Tools::getValue('start') != null && Tools::getValue('limit') != null) {
                $limitStr = ' LIMIT ' . Tools::getValue('start') . ', ' . Tools::getValue('limit');
            } else if (Tools::getValue('limit') != null) {
                $limitStr = ' LIMIT ' . Tools::getValue('limit');
            }

            $ids = array();

            if (Tools::getValue('ids') != null) {
                $ids = explode(',', Tools::getValue('ids'));
            }

            $date_from = null;
            if (Tools::getValue('date_from') != null) {
                $date_from = Tools::getValue('date_from');
            }

            require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '../helpers.php';
            $advanced_pack_ids = NxsHelpers::getAdvancedPackIds();

            $debug_tab = array();

            // '' as valeur_attr  ,
            // '' as nom_attr  ,
            // GROUP_CONCAT(attlang.name SEPARATOR '|') as valeur_attr,
            // GROUP_CONCAT(grouplang.`name` SEPARATOR '|') as nom_attr  ,

            // attlang.name   as valeur_attr  ,
            // grouplang.`name`   as nom_attr  ,

            $prod_query = $this->getProductsQuery($idShop, $langID, $only_active, $date_from, $ids, $limitStr);

            //   GROUP BY idattr
            //  AND prshop.`id_product` IN ($product_ids_joined)

            $liste_prod = Db::getInstance()->executeS($prod_query);
            if (count($liste_prod) == 0) {
                die(Tools::jsonEncode($main_products_array, JSON_UNESCAPED_SLASHES));
                return;
            }

            // $debug_tab = $liste_prod;
            $debug_tab = $prod_query;

            // $lien_base = _PS_BASE_URL_ . __PS_BASE_URI__ . Language::getIsoById($langID);
            $id_prod_current = 0;
            $tab_attributs = array();
            $product = new Product();
            $prix_base = 0;
            $prix_promo = 0;
            $id_image = 0;
            $id_image_path = 0;

            $count_products = count($liste_prod);

            //https://fungenerators.com/random/barcode/ean13

            // die(Tools::jsonEncode($liste_prod, JSON_UNESCAPED_SLASHES));
            // return;

            foreach ($liste_prod as $rowListeProd) {
                $id_prod_current = (int) $rowListeProd['id_product'];
                $product_index_from_array = array_search($id_prod_current, array_column($main_products_array, 'id'));
                $tab_attributs = array();
                if (!NxsHelpers::productIsPack($id_prod_current, $advanced_pack_ids)) {
                    $tab_attributs = $this->getProductAttributesDataFromQueryResult($id_prod_current, $main_products_array, $rowListeProd);
                }
                if ($product_index_from_array === false) {
                    //Instance nouveau produit a chaque nouveau
                    $product = new Product($rowListeProd['id_product'], false, $langID, $idShop);
                    $product->loadStockData();

                    if ($product->id_manufacturer) {
                        $product->manufacturer_name = Manufacturer::getNameById((int) $product->id_manufacturer);
                    } else {
                        $product->manufacturer_name = '';
                    }

                    // Calcul de l'url de l'image de couverture
                    $id_image = $rowListeProd['id_image'];
                    $id_image_path = '';
                    for ($i = 0; $i < Tools::strlen($id_image); $i++) {
                        $id_image_path .= $id_image[$i] . '/';
                    }

                    $category = Category::getLinkRewrite((int) $product->id_category_default, (int) $langID);
                    $lien_produit = $this->context->link->getProductLink($product, null, $category, null, $langID, $idShop);

                    $this->assemblage_produit(
                        $main_products_array,
                        $lien_produit,
                        $product,
                        $id_image_path,
                        $id_image,
                        $tab_attributs,
                        $advanced_pack_ids
                    );
                }
            }

            $count_tab_products = count($main_products_array);
            if ($count_tab_products > 0) {

                $first_product_id = (int) $main_products_array[0]['id'];

                if (!NxsHelpers::productIsPack($first_product_id, $advanced_pack_ids)) {
                    $this->loadProductDeclinaisonsData($main_products_array, $idShop, $langID, $only_active, $first_product_id);
                }

                if ($count_tab_products > 1) {
                    $last_product_id = (int) $main_products_array[$count_tab_products - 1]['id'];
                    if (!NxsHelpers::productIsPack($last_product_id, $advanced_pack_ids)) {
                        $this->loadProductDeclinaisonsData($main_products_array, $idShop, $langID, $only_active, $last_product_id);
                    }
                }

                foreach ($main_products_array as $product_wrapper_key => $product_wrapper) {
                    if (isset($product_wrapper['product_param']) && $product_wrapper['product_param']) {
                        if (count($product_wrapper['declinaisons']) > 0) {
                            foreach ($product_wrapper['declinaisons'] as $attribute_key => $attribute) {
                                if (!isset($attribute['id']) || !$attribute['id']) {
                                    continue;
                                }
                                $category = Category::getLinkRewrite((int) $product_wrapper['product_param']->id_category_default, (int) $langID);

                                $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['url'] = $this->context->link->getProductLink($product_wrapper['product_param'], null, $category, null, $langID, $idShop, $attribute['id'], false, false, true);
                                $prix_attribut = $product_wrapper['product_param']->getPrice(true, (int) $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['id'], 6, null, false, true, 1);
                                $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['prix_declinaison'] = $prix_attribut;

                                $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['quantity'] = StockAvailable::getQuantityAvailableByProduct($product_wrapper['product_param']->id, $attribute['id']);

                                $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['can_be_ordered'] = false;

                                if ($main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['quantity'] == 0) {
                                    if ($product_wrapper['product_param']->isAvailableWhenOutOfStock($product_wrapper['product_param']->out_of_stock)) {
                                        $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['can_be_ordered'] = true;
                                    } else {
                                        $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['can_be_ordered'] = false;
                                    }
                                } else {
                                    $main_products_array[$product_wrapper_key]['declinaisons'][$attribute_key]['can_be_ordered'] = true;
                                }
                            }
                        }
                        unset($main_products_array[$product_wrapper_key]['product_param']);
                    }
                }
            }
        } catch (Exception $ex) {
            $trace = $ex->getTraceAsString();
            $message = $ex->getMessage();
            // $error_data = array("error" => $message, "trace" => $trace);
            $main_products_array = array("error" => $message, "trace" => $trace);
            // die(Tools::jsonEncode($main_products_array, JSON_UNESCAPED_SLASHES));
        }

        // array_unshift($main_products_array, array('advanced_pack_ids' => $advanced_pack_ids));
        // array_unshift($main_products_array, array('debug' => $check_advanced_pack_plugin_active));


        die(Tools::jsonEncode($main_products_array, JSON_UNESCAPED_SLASHES));
        // die(Tools::jsonEncode($debug_tab, JSON_UNESCAPED_SLASHES));
    }

    public function assemblage_produit(
        &$main_products_array_param,
        $lien_produit,
        $product_param,
        $id_image_path_param,
        $id_image_param,
        $tab_attributs_param,
        $advanced_pack_ids,
        $debug = '',
        $debug2 = ''
    ) {
        // Calcul des prix
        $prix_base = Tools::ps_round($product_param->getPrice(true, null, 6, null, false, false, 1), 2);
        $prix_promo = Tools::ps_round($product_param->getPrice(true, null, 6, null, false, true, 1), 2);


        //TODO
        //AdvancedPack::getPackPrice
        $data = array(
            'url' => $lien_produit,
            // $lien_base_param . '/index.php?controller=product&id_product=' . $id_prod_current_param,
            'nom' => $product_param->name,
            'prix_base' => $prix_base,
            'prix_promo' => $prix_promo,
            'url_image' => _PS_BASE_URL_ . __PS_BASE_URI__ . 'img/p/' . $id_image_path_param . $id_image_param . '.jpg',
            'declinaisons' => $tab_attributs_param,
            //   'id' => strval( $product_param->id),
            'id' => $product_param->id,
            'wholesale_price' => $product_param->wholesale_price,
            'id_category_default' => $product_param->id_category_default,
            'manufacturer_name' => $product_param->manufacturer_name,
            'active' => $product_param->active,
            'visibility' => $product_param->visibility,
            'ean13' => $product_param->ean13,
            'reference' => $product_param->reference,
        );
        if ($debug) {
            $data['debug'] = $debug;
        }
        if ($debug2) {
            $data['debug2'] = $debug2;
        }
        $data['prix_ht'] = $product_param->getPrice(false, null, 6, null, false, false, 1);

        // $data['tva'] = round((($prix_base_param /  $data['prix_ht']) - 1) * 100, 2);
        $data['tva'] = 0;
        if (isset($data['prix_ht']) && !empty($data['prix_ht']) && $data['prix_ht'] != 0) {
            $data['tva'] = round((($prix_base / $data['prix_ht']) - 1), 3);
        }

        $data['categories'] = $product_param->getCategories();
        $data['product_param'] = $product_param;
        $data['date_upd'] = $product_param->date_upd;
        // $data['out_of_stock'] = $product_param->out_of_stock;
        $data['quantity'] = $product_param->quantity;
        // $data['out_of_stock'] = $product_param->quantity == 0;
        // $data['out_of_stock'] = $product_param->out_of_stock;
        $data['can_be_ordered'] = false;

        if ($product_param->quantity == 0) {
            if ($product_param->isAvailableWhenOutOfStock($product_param->out_of_stock)) {
                $data['can_be_ordered'] = true;
            } else {
                $data['can_be_ordered'] = false;
            }
        } else {
            $data['can_be_ordered'] = true;
        }
        $data['out_of_stock_setting'] =  $product_param->out_of_stock;

        // Pack

        if (NxsHelpers::productIsPack($product_param->id, $advanced_pack_ids)) {
            $data['is_pack'] = true;
        }

        array_push($main_products_array_param, $data);
    }
}
