<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => ProductsStats.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectProductsStatsModuleFrontController extends ModuleFrontController
{
    public function array_sort($array, $on, $order = SORT_ASC)
    {
        $new_array = array();
        $sortable_array = array();

        if (count($array) > 0) {
            foreach ($array as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if ($k2 == $on) {
                            $sortable_array[$k] = $v2;
                        }
                    }
                } else {
                    $sortable_array[$k] = $v;
                }
            }

            switch ($order) {
                case SORT_ASC:
                    asort($sortable_array);
                    break;
                case SORT_DESC:
                    arsort($sortable_array);
                    break;
            }

            foreach ($sortable_array as $k => $v) {
                $new_array[$k] = $array[$k];
            }
        }

        return $new_array;
    }
    // $this->module is the instance of the module responsible of the controller.
    // $this->context delivers the result of Context::getContext()

    public function initContent()
    {
        $this->ajax = true;
        //  header('Content-disposition: attachment; filename=liste-produits.json');
        header('Content-type: application/json');

        $cle_module = Configuration::get('PRIXANCONNECT_CLE');
        if (Tools::getValue('key') == false || Tools::getValue('key') != $cle_module) {
            die(Tools::jsonEncode('erreur d\'autorisation'));
            return;
        }
        //parametre
        $idShop = (int) $this->context->shop->id;
        if (Tools::getValue('id_shop') != null && (int) Tools::getValue('id_shop') != null > 0) {
            $idShop = (int) Tools::getValue('id_shop');
        }

        $querySales = "SELECT producttable.id_product, od.sales, view_counter.views FROM 
        `" . _DB_PREFIX_ . "product` AS producttable
         LEFT JOIN  `" . _DB_PREFIX_ . "product_shop` AS prshop  ON producttable.`id_product`= prshop.`id_product`
        LEFT JOIN ( SELECT product_id, sum(product_quantity) AS sales FROM `" . _DB_PREFIX_ . "order_detail` GROUP BY product_id ) od ON (od.product_id = producttable.id_product) 
        LEFT JOIN     (SELECT p.`id_object` as obj_id ,
        SUM(pv.counter) AS views FROM " . _DB_PREFIX_ . "page_viewed pv
        LEFT JOIN " . _DB_PREFIX_ . "page p ON pv.id_page = p.id_page
        LEFT JOIN " . _DB_PREFIX_ . "page_type pt ON p.id_page_type = pt.id_page_type
        WHERE pt.name = \"product\" GROUP BY  p.id_object ) view_counter on (view_counter.obj_id=producttable.`id_product`)
        WHERE prshop.`active` = 1 AND prshop.`id_shop` = " . $idShop;


        $querySales2 = "SELECT product_id, product_attribute_id, sum(product_quantity) AS sales FROM `" . _DB_PREFIX_ . "order_detail` order_details_alias 
        LEFT JOIN  `" . _DB_PREFIX_ . "product` AS producttable  ON producttable.`id_product`= order_details_alias.`product_id`
        LEFT JOIN  `" . _DB_PREFIX_ . "product_shop` AS prshop  ON order_details_alias.`product_id`= prshop.`id_product`
        WHERE prshop.`active` = 1 AND prshop.`id_shop` = " . $idShop .
            " GROUP BY product_id, product_attribute_id ";



        $queryViews2 = "
        (SELECT p.`id_object` as obj_id ,
        SUM(pv.counter) AS views FROM " . _DB_PREFIX_ . "page_viewed pv
        LEFT JOIN " . _DB_PREFIX_ . "page p ON pv.id_page = p.id_page
        LEFT JOIN " . _DB_PREFIX_ . "page_type pt ON p.id_page_type = pt.id_page_type
        WHERE pt.name = \"product\" GROUP BY  p.id_object ) view_counter on (view_counter.obj_id=producttable.`id_product`)
        
        SELECT product_id, product_attribute_id, sum(product_quantity) AS sales FROM `" . _DB_PREFIX_ . "order_detail` order_details_alias 
        LEFT JOIN  `" . _DB_PREFIX_ . "product` AS producttable  ON producttable.`id_product`= order_details_alias.`product_id`
        LEFT JOIN  `" . _DB_PREFIX_ . "product_shop` AS prshop  ON order_details_alias.`product_id`= prshop.`id_product`
        WHERE prshop.`active` = 1 AND prshop.`id_shop` = " . $idShop .
            " GROUP BY product_id, product_attribute_id ";

        $statsSales = Db::getInstance()->executeS($querySales);
        // $statsSales2 = Db::getInstance()->executeS($querySales2);

        // die(Tools::jsonEncode($statsSales2));

        $stats = array();
        foreach ($statsSales as $statSale) {
            if (!$statSale['sales'])
                $statSale['sales'] = 0;
            else
                $statSale['sales'] = intval($statSale['sales']);

            if (!$statSale['views'])
                $statSale['views'] = 0;
            else
                $statSale['views'] = intval($statSale['views']);

            $stats[] = array(
                'id' => intval($statSale['id_product']),
                'sales' => $statSale['sales'],
                'views' => $statSale['views'],
            );
        }

        $stats = $this->array_sort($stats, 'sales', SORT_DESC);
        $stats = array_values($stats);

        die(Tools::jsonEncode($stats));
    }
}
