/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*/
var nxsGenericError = 'Une erreur s\'est produite, veuillez réessayer ultérieurement.';
var nxsLoadingBackgroundOverlaySelector = 'nxs-loading-background-overlay';
var nxsCheckSteps = [];

function nxsGetOrCreateElement(id, type, parent, attrs) {
    var element = document.getElementById(id);
    if (!element) {
        element = document.createElement(type);
        element.setAttribute('id', id);
        if (attrs) {
            for (var index = 0; index < attrs.length; index++) {
                var attribute = attrs[index];
                element.setAttribute(attribute.name, attribute.value);
            }
        }
        if (parent)
            parent.appendChild(element);
        else
            document.body.appendChild(element);
    }
    return element;
}

function nxsShowMainLoader(message) {
    var loadingOverlay = nxsGetOrCreateElement(nxsLoadingBackgroundOverlaySelector, 'div', null, [{ name: 'class', value: 'nxs-background-overlay' }]);
    if (!loadingOverlay)
        return;
    if (!message)
        message = '';
    loadingOverlay.innerHTML = '<div class="nxs-main-loader"></div><div class="nxs-loading-message">' + message + '</div>';
    loadingOverlay.style.display = 'block';
}
function nxsHideMainLoader() {
    var loadingOverlay = nxsGetOrCreateElement(nxsLoadingBackgroundOverlaySelector, 'div', null, [{ name: 'class', value: 'nxs-background-overlay' }]);
    loadingOverlay.style.display = 'none';
}


function nxsSendRequest(url, options) {
    if (typeof jQuery === 'undefined')
        return;
    // console.log("Log: sendWordpressAjaxAction -> options", options);
    if (!url)
        return;
    if (!options)
        options = {};
    if (!options.method)
        options.method = 'GET';
    if (!options.loadingMessage)
        options.loadingMessage = 'Chargement...';
    var errorMessage = null;
    // nxsShowMainLoader(options.loadingMessage);
    var isFormData = false;
    if (options.formRef) {
        var formData = new FormData(options.formRef[0]);
        isFormData = true;
        options.data = formData;
    }
    if (options.formData) {
        options.data = options.formData;
        isFormData = true;
    }

    if (typeof options.json === 'undefined')
        options.json = true;
    if (!options.data)
        options.data = {};

    if (options.json)
        options.data = JSON.stringify(options.data);
    var ajaxOptions = {
        type: options.method,
        url: url,
        data: options.data,
        dataType: 'json',
    };
    if (options.json) {
        ajaxOptions.contentType = "application/json; charset=utf-8";
        ajaxOptions.dataType = 'json';
    }
    if (isFormData) {
        ajaxOptions.processData = false;
        ajaxOptions.contentType = false;
    }
    var returned = null;
    jQuery.ajax(ajaxOptions).done(function (response) {
        // if (response && response.success) {
        //     if (options.formRef && options.resetFormOnSuccess)
        //         options.formRef[0].reset();
        //     returned = response;
        // }
        // else if (response.data) {
        //     errorMessage = response.data;
        // }
        // else {
        //     errorMessage = nxsGenericError;
        // }

        returned = response;

    }).fail(function (err) {
        console.error("Log: send request -> err", err);
        // errorMessage = nxsGenericError;
        // returned = nxsGenericError;
        if (err && err.responseJSON)
            returned = err.responseJSON;
        else {
            errorMessage = nxsGenericError;
        }

    })
        .always(function () {
            // nxsHideMainLoader();
            if (errorMessage) {
                if (options.error) {
                    options.error(errorMessage);
                }
            }
            else {
                if (options.success) {
                    options.success(returned);
                }
            }
        });
}
function nxsGetInjectedVariable(varName) {
    if (typeof globalThis['nxs_injected_js_' + varName] !== 'undefined')
        return globalThis['nxs_injected_js_' + varName];
    return '';
}

function nxsShowCheckPrixanLoading(loading) {

    var elementResult = document.getElementById('check-prixan-connection-result-wrapper');
    var elementLoadingList = document.getElementsByClassName('check-prixan-connection-loader-wrapper');
    if (elementLoadingList) {
        for (var index = 0; index < elementLoadingList.length; index++) {
            var elementLoadingItem = elementLoadingList[index];
            if (loading)
                elementLoadingItem.style.display = 'flex';
            else
                elementLoadingItem.style.display = 'none';
        }
    }
    if (elementResult) {
        if (loading)
            elementResult.style.display = 'none';
        else
            elementResult.style.display = 'flex';
    }
}


function nxsShowPrixanResult(success, message) {
    // console.log("Log ~ file: back.js ~ line 165 ~ nxsShowPrixanResult ~ message", message);
    var elementResult = document.getElementById('check-prixan-connection-result-wrapper');
    if (elementResult) {
        elementResult.style.display = 'flex';
    }

    var elementOk = document.getElementById('check-prixan-connection-result-ok-wrapper');
    if (elementOk) {
        if (success)
            elementOk.style.display = 'flex';
        else
            elementOk.style.display = 'none';
    }


    var elementKo = document.getElementById('check-prixan-connection-result-ko-wrapper');
    var elementResultErrorMessage = document.getElementById('prixan-error-message-wrapper');

    if (elementKo) {
        if (!success) {
            elementKo.style.display = 'flex';
            if (message && elementResultErrorMessage) {
                elementResultErrorMessage.innerHTML = '<b>' + message + '</b>';
                elementResultErrorMessage.style.display = 'flex';
            }
        }
        else {
            elementKo.style.display = 'none';
            if (elementResultErrorMessage)
                elementResultErrorMessage.style.display = 'none';
        }
    }
}
function nxsSetResponsePrixanDataDebug(data) {
    var element = document.getElementById('response-prixan-data-debug');
    if (!element)
        return;
    element.innerHTML = data;
}
function nxsSetSendPrixanDataDebug(data) {
    var element = document.getElementById('send-prixan-data-debug');
    if (!element)
        return;
    element.innerHTML = data;
}
function nxsSetResponsePrixanDataDebugFull(data) {
    var element = document.getElementById('response-prixan-data-debug-full');
    if (!element)
        return;
    element.innerHTML = data;
}


function nxsShowOrHideContentConnectedState(connected) {
    var elementSubscribe = document.getElementById('subscribe-to-prixan-buttons-wrapper');
    var elementDashboard = document.getElementById('access-to-prixan-dashboard-buttons-wrapper');
    var elementMessageConnect = document.getElementById('connect-to-prixan-message-wrapper');
    if (connected) {

        if (elementSubscribe)
            elementSubscribe.style.display = 'none';
        if (elementDashboard)
            elementDashboard.style.display = 'flex';
        if (elementMessageConnect)
            elementMessageConnect.style.display = 'none';

    }
    else {
        if (elementSubscribe)
            elementSubscribe.style.display = 'flex';
        if (elementDashboard)
            elementDashboard.style.display = 'none';
        if (elementMessageConnect)
            elementMessageConnect.style.display = 'flex';

    }
}
function nxsPrixanConnectRequest(successCb, errorCb) {

    var dataToSend = {
        url: nxsGetInjectedVariable('url'),
        key: nxsGetInjectedVariable('key'),
        domain: nxsGetInjectedVariable('domain'),
        cms: nxsGetInjectedVariable('cms'),
        version: nxsGetInjectedVariable('version'),
        module_base_url: nxsGetInjectedVariable('module_base_url'),
        id_shop: nxsGetInjectedVariable('id_shop'),
        plugin_version: nxsGetInjectedVariable('plugin_version'),
        shops: nxsGetInjectedVariable('shops'),
        ip: nxsGetInjectedVariable('ip'),
    };

    nxsSetSendPrixanDataDebug(JSON.stringify(dataToSend));
    nxsShowCheckPrixanLoading(true);
    nxsSendRequest('https://app.prixan.com/check-prixan-connect', {
        data: dataToSend,
        method: 'POST', success: function (response) {
            // console.log("Log ~ file: back.js ~ line 274 ~ nxsPrixanConnectRequest ~ response", response);

            // var responseError = nxsGenericError;
            // nxsShowCheckPrixanLoading(false);
            var responseOk = false;
            if (response) {
                responseOk = response.check === 'success';
                responseError = (response.error) || nxsGenericError;
            }
            nxsShowOrHideContentConnectedState(responseOk);
            // nxsShowPrixanResult(responseOk, responseError);


            nxsSetResponsePrixanDataDebug(JSON.stringify(response));
            // // nxsSetResponsePrixanDataDebugFull(JSON.stringify(response));

            if (responseOk) {
                if (successCb) {
                    successCb();
                }
            }
            else {
                if (errorCb) {
                    errorCb();
                }
            }

        },
        error: function (err) {
            console.log("Log ~ file: back.js ~ line 295 ~ nxsPrixanConnectRequest ~ err", err);
            // nxsShowCheckPrixanLoading(false);
            // nxsShowPrixanResult(false, err);
            // nxsShowOrHideContentConnectedState(false);

            if (errorCb) {
                errorCb();
            }
        }
    });

    // $data = array(
    //     "url" => $this -> getProductsLink(),
    //     "key" => $prixan_key,
    //     "domain" => $_SERVER['SERVER_NAME'],
    //     "cms" => "prestashop",
    //     "version" => _PS_VERSION_,
    //     "ip" => $this -> getUserIpAddr(),
    //     'module_base_url' => $this -> getModuleBaseUrl(),
    //     'id_shop' =>(int) $this -> context -> shop -> id,
    //     'plugin_version' => $this -> version,
    //     'shops' => $this -> getShopsList(),
    // );
}


function nxsTestLocalProductsFetchRequest(successCb, errorCb) {

    nxsShowCheckPrixanLoading(true);
    nxsSendRequest(nxsGetInjectedVariable('module_base_url') + '/ConnectionTest?test-products-fetch=true', {
        // data: dataToSend,
        method: 'POST', success: function (response) {
            // console.log("Log ~ file: back.js ~ line 274 ~ nxsPrixanConnectRequest ~ response", response);

            // var responseError = nxsGenericError;
            // nxsShowCheckPrixanLoading(false);
            var responseOk = false;
            if (response) {
                responseOk = response.success === true;
                responseError = (response.error) || nxsGenericError;
            }
            // nxsShowOrHideContentConnectedState(responseOk);
            // nxsShowPrixanResult(responseOk, responseError);


            // nxsSetResponsePrixanDataDebug(JSON.stringify(response));
            // // nxsSetResponsePrixanDataDebugFull(JSON.stringify(response));
            // nxsSetResponsePrixanDataDebug(JSON.stringify(response));

            if (responseOk) {
                if (successCb) {
                    successCb();
                }
            }
            else {
                if (errorCb) {
                    errorCb();
                }
            }

        },
        error: function (err) {
            console.log("Log ~ file: back.js ~ line 295 ~ nxsPrixanConnectRequest ~ err", err);
            // nxsShowCheckPrixanLoading(false);
            // nxsShowPrixanResult(false, err);
            // nxsShowOrHideContentConnectedState(false);

            if (errorCb) {
                errorCb();
            }
        }
    });

    // $data = array(
    //     "url" => $this -> getProductsLink(),
    //     "key" => $prixan_key,
    //     "domain" => $_SERVER['SERVER_NAME'],
    //     "cms" => "prestashop",
    //     "version" => _PS_VERSION_,
    //     "ip" => $this -> getUserIpAddr(),
    //     'module_base_url' => $this -> getModuleBaseUrl(),
    //     'id_shop' =>(int) $this -> context -> shop -> id,
    //     'plugin_version' => $this -> version,
    //     'shops' => $this -> getShopsList(),
    // );
}


function nxsTestRemoteProductsFetchRequest(successCb, errorCb) {

    nxsShowCheckPrixanLoading(true);
    nxsSendRequest(nxsGetInjectedVariable('module_base_url') + '/ConnectionTest?test-products-fetch=true', {
        // data: dataToSend,
        method: 'POST', success: function (response) {
            // console.log("Log ~ file: back.js ~ line 274 ~ nxsPrixanConnectRequest ~ response", response);

            // var responseError = nxsGenericError;
            // nxsShowCheckPrixanLoading(false);
            var responseOk = false;
            if (response) {
                responseOk = response.success === true;
                responseError = (response.error) || nxsGenericError;
            }
            // nxsShowOrHideContentConnectedState(responseOk);
            // nxsShowPrixanResult(responseOk, responseError);


            // nxsSetResponsePrixanDataDebug(JSON.stringify(response));
            // // nxsSetResponsePrixanDataDebugFull(JSON.stringify(response));
            // nxsSetResponsePrixanDataDebug(JSON.stringify(response));

            if (responseOk) {
                if (successCb) {
                    successCb();
                }
            }
            else {
                if (errorCb) {
                    errorCb();
                }
            }

        },
        error: function (err) {
            console.log("Log ~ file: back.js ~ line 295 ~ nxsPrixanConnectRequest ~ err", err);
            // nxsShowCheckPrixanLoading(false);
            // nxsShowPrixanResult(false, err);
            // nxsShowOrHideContentConnectedState(false);

            if (errorCb) {
                errorCb();
            }
        }
    });

    // $data = array(
    //     "url" => $this -> getProductsLink(),
    //     "key" => $prixan_key,
    //     "domain" => $_SERVER['SERVER_NAME'],
    //     "cms" => "prestashop",
    //     "version" => _PS_VERSION_,
    //     "ip" => $this -> getUserIpAddr(),
    //     'module_base_url' => $this -> getModuleBaseUrl(),
    //     'id_shop' =>(int) $this -> context -> shop -> id,
    //     'plugin_version' => $this -> version,
    //     'shops' => $this -> getShopsList(),
    // );
}


function nxsRefreshCheckStepsLayout() {
    var elementResult = document.getElementById('check-prixan-connection-result-workflow-wrapper');
    if (!elementResult)
        return;

    var htmlContent = '';

    for (var index = 0; index < nxsCheckSteps.length; index++) {
        var item = nxsCheckSteps[index];
        if (item.result === null && !item.loading) {
            continue;
        }
        htmlContent += '<div class="prixan-workflow-item">';

        if (item.loading) {
            htmlContent += '<div class="check-prixan-connection-loader-wrapper"><div class="nxs-main-loader"></div><div>' + item.loadingMessage + '</div></div>';
        }
        else if (item.result === true) {
            htmlContent += '<div><i class="material-icons" style="color:green;margin-right:18px">check_circle</i></div>';
        }
        else if (item.result === false) {
            htmlContent += '<div><i class="material-icons" style="color:red;margin-right:18px">warning</i></div>';
        }

        if (!item.loading) {
            htmlContent += '<div>' + item.label + '</div>';
        }

        htmlContent += '</div>';

    }
    elementResult.innerHTML = htmlContent;


}

function nxsSetWorkflowSteps() {
    nxsCheckSteps = [
        {
            loadingMessage: 'Tentative de connexion à Prixan...',
            result: null,
            loading: false,
            label: 'Connexion à Prixan',
            methodName: 'nxsPrixanConnectRequest',
        },
        {
            loadingMessage: 'Tentative de récupération des produits (local)...',
            result: null,
            loading: false,
            label: 'Récupération des produits (local)',
            methodName: 'nxsTestLocalProductsFetchRequest',
        },
        // {
        //     loadingMessage: 'Tentative de récupération des produits (distant)...',
        //     result: null,
        //     loading: false,
        //     label: 'Récupération des produits (distant)',
        //     methodName: 'nxsTestRemoteProductsFetchRequest',
        // },
    ];
}

function nxsStartWorkflow(step) {
    if (typeof step === 'undefined')
        step = 0;
    // console.log("Log ~ file: back.js ~ line 453 ~ nxsStartWorkflow ~ window[nxsCheckSteps[step].methodName]", window[nxsCheckSteps[step].methodName]);
    // console.log("Log ~ file: back.js ~ line 453 ~ nxsStartWorkflow ~ window[nxsCheckSteps[step].methodName]", nxsCheckSteps[step].methodName);
    nxsRefreshCheckStepsLayout();

    if (step >= nxsCheckSteps.length)
        return;

    if (typeof window[nxsCheckSteps[step].methodName] !== 'undefined') {

        nxsCheckSteps[step].loading = true;
        nxsRefreshCheckStepsLayout();


        window[nxsCheckSteps[step].methodName](function () {
            //success
            nxsCheckSteps[step].loading = false;
            nxsCheckSteps[step].result = true;

            nxsRefreshCheckStepsLayout();

            nxsStartWorkflow(step + 1);
        }, function (err) {
            //error
            nxsCheckSteps[step].loading = false;
            nxsCheckSteps[step].result = false;

            nxsRefreshCheckStepsLayout();

            nxsStartWorkflow(step + 1);


        });
    }

}



nxsShowCheckPrixanLoading(false);

document.addEventListener("DOMContentLoaded", function (event) {
    if (typeof jQuery === 'undefined')
        return;
    // nxsPrixanConnectRequest(null, function () {

    // });
    nxsSetWorkflowSteps();
    nxsStartWorkflow();
});